// author: craig cox
//         rea computing, inc.
//         c.airspeed_applet@reacomp.com

import java.awt.*;

// this class is a canvas that displays arrows pointing to the cardinal
// headings

class GroundspeedCanvas extends Canvas
{
    Container    m_container;

    // constructor that stores the container that will hold the canvas

    GroundspeedCanvas( Container container )
    {
        super( );

        // store the container that will hold the canvas

        m_container = container;
    }

    // override the paint method to draw the arrows

    public void paint( Graphics g )
    {
        int         nWidth;
        int         nHeight;
    
        // get the width and height of this canvas

        nWidth = this.size( ).width;
        nHeight = this.size( ).height;
        
        // draw the east/west lines and arrowheads

        g.drawLine( 5, nHeight / 2, nWidth - 6, nHeight / 2 );
        g.drawLine( 5, nHeight / 2, 10, nHeight / 2 - 5 );
        g.drawLine( 5, nHeight / 2, 10, nHeight / 2 + 5 );
        g.drawLine( nWidth - 6, nHeight / 2, nWidth - 11, nHeight / 2 - 5 );
        g.drawLine( nWidth - 6, nHeight / 2, nWidth - 11, nHeight / 2 + 5 );
        
        // draw the north/south lines and arrowheads

        g.drawLine( nWidth / 2, 5, nWidth / 2, nHeight - 6 );
        g.drawLine( nWidth / 2, 5, nWidth / 2 - 5, 10 );
        g.drawLine( nWidth / 2, 5, nWidth / 2 + 5, 10 );
        g.drawLine( nWidth / 2, nHeight - 6, nWidth / 2 - 5, nHeight - 11 );
        g.drawLine( nWidth / 2, nHeight - 6, nWidth / 2 + 5, nHeight - 11 );
    }

    // the preferred and minimum sizes for the canvas are one-fifth the
    // container width and one-third the container height

    public Dimension minimumSize( )
    {
        Dimension d = m_container.size( );

        return new Dimension( d.width / 5, d.height / 3 );
    }

    public Dimension preferredSize( )
    {
        return this.minimumSize( );
    }

}
