// author: craig cox
//         rea computing, inc.
//         c.airspeed_applet@reacomp.com

import java.awt.*;
import java.util.Vector;

// this class is a canvas that displays the groundtrack of the aircraft,
// either no-wind or wind-corrected

class GroundtrackCanvas extends Canvas
{
    private boolean             m_bApplyWind = false;
    private TrueAirspeedApplet  m_applet;
    private Vector              i_vTrack = new Vector( );

    // constructor that stores the TrueAirspeedApplet containing the canvas

    GroundtrackCanvas( TrueAirspeedApplet myApplet )
    {
        m_applet = myApplet;
    }
    
    // set the mode so the canvas displays the no-wind (false) or
    // wind-corrected (true) ground track

    public void setPaintMode( boolean myApplyWind )
    {
        m_bApplyWind = myApplyWind;
    }
    
    // override the paint method to display the ground track

    public void paint( Graphics g )
    {
        double                      dScale;
        int                         nDirectionCount;
        int                         nDx;
        int                         nDy;
        int                         nHeight;
        int                         nMaxX;
        int                         nMaxY;
        int                         nMinX;
        int                         nMinY;
        int                         nOldX;
        int                         nOldY;
        int                         nSouthWind;
        int                         nTrueAirspeed;
        int                         nWestWind;
        int                         nWidth;
        int                         nX;
        int                         nXOffset;
        int                         nY;
        int                         nYOffset;
        String                      sDirectionOrder =
                                        m_applet.getDirectionOrder( );
        TrueAirspeedWindEstimate    estimate = m_applet.getEstimate( );
        Vector                      v = new Vector( );
    
        // get the estimated airspeed and wind (the southerly and westerly
        // components)

        nTrueAirspeed = ( int ) Math.round( estimate.getTrueAirspeed( ) );
        nSouthWind = ( int ) Math.round( estimate.getWind( 'S' ) );
        nWestWind = ( int ) Math.round( estimate.getWind( 'W' ) );
        
        nDx = 0;
        nDy = 0;
        nMinX = 0;
        nMaxX = 0;
        nMinY = 0;
        nMaxY = 0;
        nX = 0;
        nY = 0;
        
        // loop through the groundspeed directions.  nDx is the amount the
        // aircraft moves to the east.  nDy is the amount the aircraft moves
        // to the north.  if a no-wind groundtrack is being drawn, use only
        // the groundspeed of the aircraft.  if a wind-corrected groundtrack
        // is being drawn, use the current estimate for wind and airspeed to
        // determine how far the aircraft has moved north (or south) and east
        // (or west).

        nDirectionCount = sDirectionOrder.length( );
        
        for ( int i = 0; i < nDirectionCount; i++ )
        {
            switch ( sDirectionOrder.charAt( i ) )
            {
                case 'N':
                {
                    if ( m_bApplyWind )
                    {
                        nDx = nWestWind;
                        nDy = nTrueAirspeed + nSouthWind;
                    }
                    else
                    {
                        nDx = 0;
                        nDy = ( int ) Math.round(
                            estimate.getGroundspeed( 'N' ) );
                    }
                    
                    break;
                }
                
                case 'E':
                {
                    if ( m_bApplyWind )
                    {
                        nDx = nTrueAirspeed + nWestWind;
                        nDy = nSouthWind;
                    }
                    else
                    {
                        nDx = ( int ) Math.round(
                            estimate.getGroundspeed( 'E' ) );
                        nDy = 0;
                    }
                    
                    break;
                }
                
                case 'S':
                {
                    if ( m_bApplyWind )
                    {
                        nDx = nWestWind;
                        nDy = nSouthWind - nTrueAirspeed;
                    }
                    else
                    {
                        nDx = 0;
                        nDy = ( int ) Math.round(
                            -estimate.getGroundspeed( 'S' ) );
                    }
                    
                    break;
                }
                
                case 'W':
                {
                    if ( m_bApplyWind )
                    {
                        nDx = nWestWind - nTrueAirspeed;
                        nDy = nSouthWind;
                    }
                    else
                    {
                        nDx = ( int ) Math.round(
                            -estimate.getGroundspeed( 'W' ) );
                        nDy = 0;
                    }
                    
                    break;
                }
            }

            // compute the new position of the aircraft the bounds of the box
            // that contains this and all previous positions

            nMaxX = Math.max( nMaxX, nX + nDx );
            nMinX = Math.min( nMinX, nX + nDx );
            nMaxY = Math.max( nMaxY, nY - nDy );
            nMinY = Math.min( nMinY, nY - nDy );
            nX += nDx;
            nY -= nDy;
            
            // add the new position to a vector

            v.addElement( new Point( nX, nY ) );
        }
        
        // get the dimensions of the canvas

        nWidth = this.size( ).width;
        nHeight = this.size( ).height;
        
        // determine the scale and offset necessary so all aircrafts positions
        // will be centered on the canvas

        dScale = Math.min( ( nWidth - 20 ) / ( double ) ( nMaxX - nMinX ),
            ( nHeight - 20 ) / ( double ) ( nMaxY - nMinY ) );
        nXOffset = ( int ) ( ( nWidth / 2 )
            - ( dScale * ( ( ( double ) nMinX + nMaxX ) / 2 ) ) );
        nYOffset = ( int ) ( ( nHeight / 2 )
            - ( dScale * ( ( ( double ) nMinY + nMaxY ) / 2 ) ) );
        
        nOldX = nXOffset;
        nOldY = nYOffset;

        // draw the lines representing the groundtracks of the airplane
        
        for ( int i = 0; i < v.size( ); i++ )
        {
            nX = ( int ) ( ( ( ( ( Point ) v.elementAt( i ) ).x ) * dScale )
                + nXOffset );
            nY = ( int ) ( ( ( ( ( Point ) v.elementAt( i ) ).y ) * dScale )
                + nYOffset );
            
            g.drawLine( nOldX, nOldY, nX, nY );
            
            nOldX = nX;
            nOldY = nY;
        }
        
        // draw arrowhead if any legs were drawn
        
        if ( nDx != 0 || nDy != 0 )
        {
            if ( Math.abs( Math.abs( ( double ) nDy / nDx )
                - Math.sqrt( 2.0 ) ) < 1 )
            {
                // closer to diagonal
                
                nX = ( nDx < 0 ) ? nX - 1 : nX + 1;
                nY = ( nDy < 0 ) ? nY + 1 : nY - 1;
                        
                g.drawLine( nX, nY, ( nDx < 0 ) ? nX + 7 : nX - 7, nY );
                g.drawLine( nX, nY, nX, ( nDy < 0 ) ? nY - 7 : nY + 7 );
            }
            else if ( Math.abs( nDy ) > Math.abs( nDx ) )
            {
                // closer to vertical

                if ( nDy < 0 )
                {
                    g.drawLine( nX, nY + 1, nX - 5, nY - 4 );
                    g.drawLine( nX, nY + 1, nX + 5, nY - 4 );
                }
                else
                {
                    g.drawLine( nX, nY - 1, nX - 5, nY + 4 );
                    g.drawLine( nX, nY - 1, nX + 5, nY + 4 );
                }
            }
            else
            {
                // closer to horizontal
                
                if ( nDx < 0 )
                {
                    g.drawLine( nX - 1, nY, nX + 4, nY - 5 );
                    g.drawLine( nX - 1, nY, nX + 4, nY + 5 );
                }
                else
                {
                    g.drawLine( nX + 1, nY, nX - 4, nY - 5 );
                    g.drawLine( nX + 1, nY, nX - 4, nY + 5 );
                }
            }   
        }
    }

    // the preferred and minimum sizes of canvas are one-third the width and
    // one-half the height of the applet

    public Dimension minimumSize( )
    {
        Dimension d = m_applet.size( );

        return new Dimension( d.width / 3, d.height / 2 );
    }

    public Dimension preferredSize( )
    {
        return this.minimumSize( );
    }
}
